/*
 * Decompiled with CFR 0.152.
 */
package com.android.product.data.api;

import com.Application;
import com.android.core.data.api.AndroidController;
import com.android.core.domain.AndroidService;
import com.android.core.domain.model.BaseResponse;
import com.android.product.domain.ProductPriceService;
import com.dto.LoginDto;
import java.util.Map;
import org.jetbrains.annotations.Nullable;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;
import springfox.documentation.annotations.ApiIgnore;

@RestController
@RequestMapping(value={"/android/product/prices"})
public class ProductPriceController
extends AndroidController<Map<String, Object>> {
    protected ProductPriceController(Application app, AndroidService<Map<String, Object>> productPriceService) {
        super(app, productPriceService);
    }

    @ApiIgnore
    @GetMapping(value={"/lastSellPrice"})
    @Nullable
    public BaseResponse<Double> getLastSellPrice(@RequestParam(value="customer-code") String customerCode, @RequestParam(value="productCode") String productCode) {
        boolean isAndroid = ((LoginDto)SecurityContextHolder.getContext().getAuthentication().getPrincipal()).isAndroid();
        if (!isAndroid) {
            return null;
        }
        BaseResponse result = ((ProductPriceService)this.service).getLastSellPrice(customerCode, productCode);
        this.log.info("GET result: " + result);
        return result;
    }
}

